/*
 * @(#)ExtendedHTMLEditorKit.java  1.0  22. Januar 2007
 *
 * Copyright (c) 2006 Fachhochschule Zentralschweiz (FHZ)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Fachhochschule Zentralschweiz. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Fachhochschule Zentralschweiz.
 */

package ch.randelshofer.html;

import java.awt.event.*;
import java.io.*;
import java.net.URL;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.text.html.parser.*;

/**
 * The ExtendedHTMLEditorKit aims to fix some quirks and issues with the
 * HTMLEditorKit that comes with Swing.
 * <p>
 * <ul>
 * <li>Properly inserts BR tags when the Enter key is pressed.</li>
 * </ul>
 *
 * @author Werner Randelshofer
 * @version 1.0 22. Januar 2007 Created.
 */
public class ExtendedHTMLEditorKit extends HTMLEditorKit {
    
    /** Creates a new instance. */
    public ExtendedHTMLEditorKit() {
    }
    /**
     * Called when the kit is being installed into the
     * a JEditorPane. 
     *
     * @param c the JEditorPane
     */
    public void install(JEditorPane c) {
        super.install(c);
        // Alter the keymap
        Keymap map = c.getKeymap();
        
        Action action = new HTMLEditorKit.InsertHTMLTextAction("InsertParagraph","<P></P>",HTML.Tag.BODY,HTML.Tag.P);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, InputEvent.SHIFT_MASK);
        map.removeKeyStrokeBinding(keyStroke);
        map.addActionForKeyStroke(keyStroke, action);
        
        action = new HTMLEditorKit.InsertHTMLTextAction("InsertBreak","<BR>",HTML.Tag.BODY,HTML.Tag.BR);
        // action = new HTMLEditorKit.InsertBreakAction();
        keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
        map.removeKeyStrokeBinding(keyStroke);
        map.addActionForKeyStroke(keyStroke, action);
        
    }
    
    public void insertHTML(HTMLDocument doc, int offset, String html,
            int popDepth, int pushDepth,
            HTML.Tag insertTag) throws
            BadLocationException, IOException {
        Parser p = getParser();
        if (p == null) {
            throw new IOException("Can't load parser");
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Invalid location", offset);
        }
        
        ParserCallback receiver = doc.getReader(offset, popDepth, pushDepth,
                insertTag);
        Boolean ignoreCharset = (Boolean)doc.getProperty
                ("IgnoreCharsetDirective");
        p.parse(new StringReader(html), receiver, (ignoreCharset == null) ?
            false : ignoreCharset.booleanValue());
        receiver.flush();
    }
    @Override public Document createDefaultDocument() {
        StyleSheet styles = getStyleSheet();
        StyleSheet ss = new StyleSheet();
        
        ss.addStyleSheet(styles);
        
        HTMLDocument doc = new HTMLDocument(ss) {
            public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth,
                    int pushDepth,
                    HTML.Tag insertTag) {
                return getReader(pos, popDepth, pushDepth, insertTag, true);
            }
            HTMLEditorKit.ParserCallback getReader(int pos, int popDepth,
                    int pushDepth,
                    HTML.Tag insertTag,
                    boolean insertInsertTag) {
                Object desc = getProperty(Document.StreamDescriptionProperty);
                if (desc instanceof URL) {
                    setBase((URL)desc);
                }
                HTMLDocument.HTMLReader reader = new HTMLDocument.HTMLReader(pos, popDepth, pushDepth,
                        insertTag/*, insertInsertTag , false,
                                true*/) {
                    /**
                     * Adds content that is basically specified entirely
                     * in the attribute set.
                     */
                    protected void addSpecialElement(HTML.Tag t, MutableAttributeSet a) {
                        // Special Hack to create proper BR Tags
                        if (t == HTML.Tag.BR) {
                            System.out.println("OptionsPanel.HTMLReader.addSpecialElement "+t+","+a);
                            a.addAttributes(charAttr);
                            a.addAttribute(StyleConstants.NameAttribute, t);
                            char[] one = new char[1];
                            one[0] = ' ';
                            ElementSpec es = new ElementSpec(
                                    a.copyAttributes(), ElementSpec.ContentType, one, 0, 1);
                            parseBuffer.addElement(es);
                        } else {
                            super.addSpecialElement(t, a);
                        }
/*
 
                                if ((t != HTML.Tag.FRAME) && (! inParagraph) && (! inPre)) {
                                    blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                                    inParagraph = true;
                                    impliedP = true;
                                }
                                if (!canInsertTag(t, a, t.isBlock())) {
                                    return;
                                }
                                if (a.isDefined(IMPLIED)) {
                                    a.removeAttribute(IMPLIED);
                                }
                                emptyAnchor = false;
                                a.addAttributes(charAttr);
                                a.addAttribute(StyleConstants.NameAttribute, t);
                                char[] one = new char[1];
                                one[0] = ' ';
                                ElementSpec es = new ElementSpec(
                                        a.copyAttributes(), ElementSpec.ContentType, one, 0, 1);
                                parseBuffer.addElement(es);
                                // Set this to avoid generating a newline for frames, frames
                                // shouldn't have any content, and shouldn't need a newline.
                                if (t == HTML.Tag.FRAME) {
                                    lastWasNewline = true;
                                }
 */
                    }
                    public void flush() throws BadLocationException {
                        super.flush();
                    }
                    
                    public void handleText(char[] data, int pos) {
                        super.handleText(data, pos);
                    }
                    
                    public void handleComment(char[] data, int pos) {
                        super.handleComment(data, pos);
                    }
                    
                    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                        super.handleStartTag(t, a, pos);
                    }
                    
                    public void handleEndTag(HTML.Tag t, int pos) {
                        super.handleEndTag(t, pos);
                    }
                    
                    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                        super.handleSimpleTag(t, a, pos);
                    }
                    
                    public void handleError(String errorMsg, int pos){
                        super.handleError(errorMsg, pos);
                    }
                    
                    /**
                     * This is invoked after the stream has been parsed, but before
                     * <code>flush</code>. <code>eol</code> will be one of \n, \r
                     * or \r\n, which ever is encountered the most in parsing the
                     * stream.
                     *
                     * @since 1.3
                     */
                    public void handleEndOfLineString(String eol) {
                        super.handleEndOfLineString(eol);
                    }
                };
                return reader;
            }
        };
        doc.setParser(getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }
}
